(window["webpackJsonp"]=window["webpackJsonp"]||[]).push([["chunk-07beaa60"],{a9ee:function(e,t,i){"use strict";(function(i,o){var n,r;
/**
 * {@link https://github.com/muaz-khan/RecordRTC|RecordRTC} is a WebRTC JavaScript library for audio/video as well as screen activity recording. It supports Chrome, Firefox, Opera, Android, and Microsoft Edge. Platforms: Linux, Mac and Windows. 
 * @summary Record audio, video or screen inside the browser.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef RecordRTC
 * @class
 * @example
 * var recorder = RecordRTC(mediaStream or [arrayOfMediaStream], {
 *     type: 'video', // audio or video or gif or canvas
 *     recorderType: MediaStreamRecorder || CanvasRecorder || StereoAudioRecorder || Etc
 * });
 * recorder.startRecording();
 * @see For further information:
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - Single media-stream object, array of media-streams, html-canvas-element, etc.
 * @param {object} config - {type:"video", recorderType: MediaStreamRecorder, disableLogs: true, numberOfAudioChannels: 1, bufferSize: 0, sampleRate: 0, desiredSampRate: 16000, video: HTMLVideoElement, etc.}
 */
function a(e,t){if(!e)throw"First parameter is required.";t=t||{type:"video"},t=new d(e,t);var i=this;function o(o){return t.disableLogs||console.log("RecordRTC version: ",i.version),o&&(t=new d(e,o)),t.disableLogs||console.log("started recording "+t.type+" stream."),p?(p.clearRecordedData(),p.record(),m("recording"),i.recordingDuration&&h(),i):(n(function(){i.recordingDuration&&h()}),i)}function n(i){i&&(t.initCallback=function(){i(),i=t.initCallback=null});var o=new s(e,t);p=new o(e,t),p.record(),m("recording"),t.disableLogs||console.log("Initialized recorderType:",p.constructor.name,"for output-type:",t.type)}function r(e){if(e=e||function(){},p){if("paused"===i.state)return i.resumeRecording(),void setTimeout(function(){r(e)},1);"recording"===i.state||t.disableLogs||console.warn('Recording state should be: "recording", however current state is: ',i.state),t.disableLogs||console.log("Stopped recording "+t.type+" stream."),"gif"!==t.type?p.stop(o):(p.stop(),o()),m("stopped")}else b();function o(o){if(p){Object.keys(p).forEach(function(e){"function"!==typeof p[e]&&(i[e]=p[e])});var n=p.blob;if(!n){if(!o)throw"Recording failed.";p.blob=n=o}if(n&&!t.disableLogs&&console.log(n.type,"->",S(n.size)),e){var r;try{r=g.createObjectURL(n)}catch(a){}"function"===typeof e.call?e.call(i,r):e(r)}t.autoWriteToDisk&&l(function(e){var i={};i[t.type+"Blob"]=e,O.Store(i)})}else"function"===typeof e.call?e.call(i,""):e("")}}function c(){p?"recording"===i.state?(m("paused"),p.pause(),t.disableLogs||console.log("Paused recording.")):t.disableLogs||console.warn("Unable to pause the recording. Recording state: ",i.state):b()}function u(){p?"paused"===i.state?(m("recording"),p.resume(),t.disableLogs||console.log("Resumed recording.")):t.disableLogs||console.warn("Unable to resume the recording. Recording state: ",i.state):b()}function f(e){postMessage((new FileReaderSync).readAsDataURL(e))}function l(e,i){if(!e)throw"Pass a callback function over getDataURL.";var o=i?i.blob:(p||{}).blob;if(!o)return t.disableLogs||console.warn("Blob encoder did not finish its job yet."),void setTimeout(function(){l(e,i)},1e3);if("undefined"===typeof Worker||navigator.mozGetUserMedia){var n=new FileReader;n.readAsDataURL(o),n.onload=function(t){e(t.target.result)}}else{var r=a(f);r.onmessage=function(t){e(t.data)},r.postMessage(o)}function a(e){try{var t=g.createObjectURL(new Blob([e.toString(),"this.onmessage =  function (eee) {"+e.name+"(eee.data);}"],{type:"application/javascript"})),i=new Worker(t);return g.revokeObjectURL(t),i}catch(o){}}}function h(e){e=e||0,"paused"!==i.state?"stopped"!==i.state&&(e>=i.recordingDuration?r(i.onRecordingStopped):(e+=1e3,setTimeout(function(){h(e)},1e3))):setTimeout(function(){h(e)},1e3)}function m(e){i&&(i.state=e,"function"===typeof i.onStateChanged.call?i.onStateChanged.call(i,e):i.onStateChanged(e))}var p,v='It seems that recorder is destroyed or "startRecording" is not invoked for '+t.type+" recorder.";function b(){!0!==t.disableLogs&&console.warn(v)}var w={startRecording:o,stopRecording:r,pauseRecording:c,resumeRecording:u,initRecorder:n,setRecordingDuration:function(e,t){if("undefined"===typeof e)throw"recordingDuration is required.";if("number"!==typeof e)throw"recordingDuration must be a number.";return i.recordingDuration=e,i.onRecordingStopped=t||function(){},{onRecordingStopped:function(e){i.onRecordingStopped=e}}},clearRecordedData:function(){p?(p.clearRecordedData(),t.disableLogs||console.log("Cleared old recorded data.")):b()},getBlob:function(){if(p)return p.blob;b()},getDataURL:l,toURL:function(){if(p)return g.createObjectURL(p.blob);b()},getInternalRecorder:function(){return p},save:function(e){p?k(p.blob,e):b()},getFromDisk:function(e){p?a.getFromDisk(t.type,e):b()},setAdvertisementArray:function(e){t.advertisement=[];for(var i=e.length,o=0;o<i;o++)t.advertisement.push({duration:o,image:e[o]})},blob:null,bufferSize:0,sampleRate:0,buffer:null,reset:function(){"recording"!==i.state||t.disableLogs||console.warn("Stop an active recorder."),p&&"function"===typeof p.clearRecordedData&&p.clearRecordedData(),p=null,m("inactive"),i.blob=null},onStateChanged:function(e){t.disableLogs||console.log("Recorder state changed:",e)},state:"inactive",getState:function(){return i.state},destroy:function(){var e=t.disableLogs;t={disableLogs:!0},i.reset(),m("destroyed"),w=i=null,A.AudioContextConstructor&&(A.AudioContextConstructor.close(),A.AudioContextConstructor=null),t.disableLogs=e,t.disableLogs||console.log("RecordRTC is destroyed.")},version:"5.6.1"};if(!this)return i=w,w;for(var y in w)this[y]=w[y];return i=this,w}
/**
 * {@link RecordRTCConfiguration} is an inner/private helper for {@link RecordRTC}.
 * @summary It configures the 2nd parameter passed over {@link RecordRTC} and returns a valid "config" object.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef RecordRTCConfiguration
 * @class
 * @example
 * var options = RecordRTCConfiguration(mediaStream, options);
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @param {object} config - {type:"video", disableLogs: true, numberOfAudioChannels: 1, bufferSize: 0, sampleRate: 0, video: HTMLVideoElement, getNativeBlob:true, etc.}
 */
function d(e,t){return t.recorderType||t.type||(t.audio&&t.video?t.type="video":t.audio&&!t.video&&(t.type="audio")),t.recorderType&&!t.type&&(t.recorderType===E||t.recorderType===B||"undefined"!==typeof N&&t.recorderType===N?t.type="video":t.recorderType===F?t.type="gif":t.recorderType===x?t.type="audio":t.recorderType===U&&(T(e,"audio").length&&T(e,"video").length?t.type="video":!T(e,"audio").length&&T(e,"video").length?t.type="video":T(e,"audio").length&&!T(e,"video").length&&(t.type="audio"))),"undefined"!==typeof U&&"undefined"!==typeof MediaRecorder&&"requestData"in MediaRecorder.prototype&&(t.mimeType||(t.mimeType="video/webm"),t.type||(t.type=t.mimeType.split("/")[0]),t.bitsPerSecond),t.type||(t.mimeType&&(t.type=t.mimeType.split("/")[0]),t.type||(t.type="audio")),t}
/**
 * {@link GetRecorderType} is an inner/private helper for {@link RecordRTC}.
 * @summary It returns best recorder-type available for your browser.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef GetRecorderType
 * @class
 * @example
 * var RecorderType = GetRecorderType(options);
 * var recorder = new RecorderType(options);
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @param {object} config - {type:"video", disableLogs: true, numberOfAudioChannels: 1, bufferSize: 0, sampleRate: 0, video: HTMLVideoElement, etc.}
 */function s(e,t){var i;return(w||p||v)&&(i=x),"undefined"!==typeof MediaRecorder&&"requestData"in MediaRecorder.prototype&&!w&&(i=U),"video"===t.type&&(w||v)&&(i=E,"undefined"!==typeof N&&"undefined"!==typeof ReadableStream&&(i=N)),"gif"===t.type&&(i=F),"canvas"===t.type&&(i=B),D()&&i!==B&&i!==F&&"undefined"!==typeof MediaRecorder&&"requestData"in MediaRecorder.prototype&&(T(e,"video").length||T(e,"audio").length)&&("audio"===t.type?"function"===typeof MediaRecorder.isTypeSupported&&MediaRecorder.isTypeSupported("audio/webm")&&(i=U):"function"===typeof MediaRecorder.isTypeSupported&&MediaRecorder.isTypeSupported("video/webm")&&(i=U)),e instanceof Array&&e.length&&(i=j),t.recorderType&&(i=t.recorderType),!t.disableLogs&&i&&i.name&&console.log("Using recorderType:",i.name||i.constructor.name),!i&&y&&(i=U),i}
/**
 * MRecordRTC runs on top of {@link RecordRTC} to bring multiple recordings in a single place, by providing simple API.
 * @summary MRecordRTC stands for "Multiple-RecordRTC".
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef MRecordRTC
 * @class
 * @example
 * var recorder = new MRecordRTC();
 * recorder.addStream(MediaStream);
 * recorder.mediaType = {
 *     audio: true, // or StereoAudioRecorder or MediaStreamRecorder
 *     video: true, // or WhammyRecorder or MediaStreamRecorder or WebAssemblyRecorder or CanvasRecorder
 *     gif: true    // or GifRecorder
 * };
 * // mimeType is optional and should be set only in advance cases.
 * recorder.mimeType = {
 *     audio: 'audio/wav',
 *     video: 'video/webm',
 *     gif:   'image/gif'
 * };
 * recorder.startRecording();
 * @see For further information:
 * @see {@link https://github.com/muaz-khan/RecordRTC/tree/master/MRecordRTC|MRecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @requires {@link RecordRTC}
 */function c(e){this.addStream=function(t){t&&(e=t)},this.mediaType={audio:!0,video:!0},this.startRecording=function(){var t,i=this.mediaType,o=this.mimeType||{audio:null,video:null,gif:null};if("function"!==typeof i.audio&&D()&&!T(e,"audio").length&&(i.audio=!1),"function"!==typeof i.video&&D()&&!T(e,"video").length&&(i.video=!1),"function"!==typeof i.gif&&D()&&!T(e,"video").length&&(i.gif=!1),!i.audio&&!i.video&&!i.gif)throw"MediaStream must have either audio or video tracks.";if(i.audio&&(t=null,"function"===typeof i.audio&&(t=i.audio),this.audioRecorder=new a(e,{type:"audio",bufferSize:this.bufferSize,sampleRate:this.sampleRate,numberOfAudioChannels:this.numberOfAudioChannels||2,disableLogs:this.disableLogs,recorderType:t,mimeType:o.audio,timeSlice:this.timeSlice,onTimeStamp:this.onTimeStamp}),i.video||this.audioRecorder.startRecording()),i.video){t=null,"function"===typeof i.video&&(t=i.video);var n=e;if(D()&&i.audio&&"function"===typeof i.audio){var r=T(e,"video")[0];b?(n=new R,n.addTrack(r),t&&t===E&&(t=U)):(n=new R,n.addTrack(r))}this.videoRecorder=new a(n,{type:"video",video:this.video,canvas:this.canvas,frameInterval:this.frameInterval||10,disableLogs:this.disableLogs,recorderType:t,mimeType:o.video,timeSlice:this.timeSlice,onTimeStamp:this.onTimeStamp,workerPath:this.workerPath,webAssemblyPath:this.webAssemblyPath,frameRate:this.frameRate,bitrate:this.bitrate}),i.audio||this.videoRecorder.startRecording()}if(i.audio&&i.video){var d=this,s=!0===D();i.audio instanceof x&&i.video?s=!1:!0!==i.audio&&!0!==i.video&&i.audio!==i.video&&(s=!1),!0===s?(d.audioRecorder=null,d.videoRecorder.startRecording()):d.videoRecorder.initRecorder(function(){d.audioRecorder.initRecorder(function(){d.videoRecorder.startRecording(),d.audioRecorder.startRecording()})})}i.gif&&(t=null,"function"===typeof i.gif&&(t=i.gif),this.gifRecorder=new a(e,{type:"gif",frameRate:this.frameRate||200,quality:this.quality||10,disableLogs:this.disableLogs,recorderType:t,mimeType:o.gif}),this.gifRecorder.startRecording())},this.stopRecording=function(e){e=e||function(){},this.audioRecorder&&this.audioRecorder.stopRecording(function(t){e(t,"audio")}),this.videoRecorder&&this.videoRecorder.stopRecording(function(t){e(t,"video")}),this.gifRecorder&&this.gifRecorder.stopRecording(function(t){e(t,"gif")})},this.pauseRecording=function(){this.audioRecorder&&this.audioRecorder.pauseRecording(),this.videoRecorder&&this.videoRecorder.pauseRecording(),this.gifRecorder&&this.gifRecorder.pauseRecording()},this.resumeRecording=function(){this.audioRecorder&&this.audioRecorder.resumeRecording(),this.videoRecorder&&this.videoRecorder.resumeRecording(),this.gifRecorder&&this.gifRecorder.resumeRecording()},this.getBlob=function(e){var t={};return this.audioRecorder&&(t.audio=this.audioRecorder.getBlob()),this.videoRecorder&&(t.video=this.videoRecorder.getBlob()),this.gifRecorder&&(t.gif=this.gifRecorder.getBlob()),e&&e(t),t},this.destroy=function(){this.audioRecorder&&(this.audioRecorder.destroy(),this.audioRecorder=null),this.videoRecorder&&(this.videoRecorder.destroy(),this.videoRecorder=null),this.gifRecorder&&(this.gifRecorder.destroy(),this.gifRecorder=null)},this.getDataURL=function(e){function t(e,t){if("undefined"!==typeof Worker){var o=i(function(e){postMessage((new FileReaderSync).readAsDataURL(e))});o.onmessage=function(e){t(e.data)},o.postMessage(e)}else{var n=new FileReader;n.readAsDataURL(e),n.onload=function(e){t(e.target.result)}}}function i(e){var t,i=g.createObjectURL(new Blob([e.toString(),"this.onmessage =  function (eee) {"+e.name+"(eee.data);}"],{type:"application/javascript"})),o=new Worker(i);if("undefined"!==typeof g)t=g;else{if("undefined"===typeof webkitURL)throw"Neither URL nor webkitURL detected.";t=webkitURL}return t.revokeObjectURL(i),o}this.getBlob(function(i){i.audio&&i.video?t(i.audio,function(o){t(i.video,function(t){e({audio:o,video:t})})}):i.audio?t(i.audio,function(t){e({audio:t})}):i.video&&t(i.video,function(t){e({video:t})})})},this.writeToDisk=function(){a.writeToDisk({audio:this.audioRecorder,video:this.videoRecorder,gif:this.gifRecorder})},this.save=function(e){e=e||{audio:!0,video:!0,gif:!0},e.audio&&this.audioRecorder&&this.audioRecorder.save("string"===typeof e.audio?e.audio:""),e.video&&this.videoRecorder&&this.videoRecorder.save("string"===typeof e.video?e.video:""),e.gif&&this.gifRecorder&&this.gifRecorder.save("string"===typeof e.gif?e.gif:"")}}a.version="5.6.1",e.exports=a,n=[],r=function(){return a}.apply(t,n),void 0===r||(e.exports=r),a.getFromDisk=function(e,t){if(!t)throw"callback is mandatory.";console.log("Getting recorded "+("all"===e?"blobs":e+" blob ")+" from disk!"),O.Fetch(function(i,o){"all"!==e&&o===e+"Blob"&&t&&t(i),"all"===e&&t&&t(i,o.replace("Blob",""))})},a.writeToDisk=function(e){console.log("Writing recorded blob(s) to disk!"),e=e||{},e.audio&&e.video&&e.gif?e.audio.getDataURL(function(t){e.video.getDataURL(function(i){e.gif.getDataURL(function(e){O.Store({audioBlob:t,videoBlob:i,gifBlob:e})})})}):e.audio&&e.video?e.audio.getDataURL(function(t){e.video.getDataURL(function(e){O.Store({audioBlob:t,videoBlob:e})})}):e.audio&&e.gif?e.audio.getDataURL(function(t){e.gif.getDataURL(function(e){O.Store({audioBlob:t,gifBlob:e})})}):e.video&&e.gif?e.video.getDataURL(function(t){e.gif.getDataURL(function(e){O.Store({videoBlob:t,gifBlob:e})})}):e.audio?e.audio.getDataURL(function(e){O.Store({audioBlob:e})}):e.video?e.video.getDataURL(function(e){O.Store({videoBlob:e})}):e.gif&&e.gif.getDataURL(function(e){O.Store({gifBlob:e})})},c.getFromDisk=a.getFromDisk,c.writeToDisk=a.writeToDisk,"undefined"!==typeof a&&(a.MRecordRTC=c);var u="Fake/5.0 (FakeOS) AppleWebKit/123 (KHTML, like Gecko) Fake/12.3.4567.89 Fake/123.45";(function(e){e&&"undefined"===typeof window&&"undefined"!==typeof i&&(i.navigator={userAgent:u,getUserMedia:function(){}},i.console||(i.console={}),"undefined"!==typeof i.console.log&&"undefined"!==typeof i.console.error||(i.console.error=i.console.log=i.console.log||function(){console.log(arguments)}),"undefined"===typeof document&&(e.document={documentElement:{appendChild:function(){return""}}},document.createElement=document.captureStream=document.mozCaptureStream=function(){var e={getContext:function(){return e},play:function(){},pause:function(){},drawImage:function(){},toDataURL:function(){return""},style:{}};return e},e.HTMLVideoElement=function(){}),"undefined"===typeof location&&(e.location={protocol:"file:",href:"",hash:""}),"undefined"===typeof screen&&(e.screen={width:0,height:0}),"undefined"===typeof g&&(e.URL={createObjectURL:function(){return""},revokeObjectURL:function(){return""}}),e.window=i)})("undefined"!==typeof i?i:null);var f=window.requestAnimationFrame;if("undefined"===typeof f)if("undefined"!==typeof webkitRequestAnimationFrame)f=webkitRequestAnimationFrame;else if("undefined"!==typeof mozRequestAnimationFrame)f=mozRequestAnimationFrame;else if("undefined"!==typeof msRequestAnimationFrame)f=msRequestAnimationFrame;else if("undefined"===typeof f){var l=0;f=function(e,t){var i=(new Date).getTime(),o=Math.max(0,16-(i-l)),n=setTimeout(function(){e(i+o)},o);return l=i+o,n}}var h=window.cancelAnimationFrame;"undefined"===typeof h&&("undefined"!==typeof webkitCancelAnimationFrame?h=webkitCancelAnimationFrame:"undefined"!==typeof mozCancelAnimationFrame?h=mozCancelAnimationFrame:"undefined"!==typeof msCancelAnimationFrame?h=msCancelAnimationFrame:"undefined"===typeof h&&(h=function(e){clearTimeout(e)}));var m=window.AudioContext;"undefined"===typeof m&&("undefined"!==typeof webkitAudioContext&&(m=webkitAudioContext),"undefined"!==typeof mozAudioContext&&(m=mozAudioContext));var g=window.URL;"undefined"===typeof g&&"undefined"!==typeof webkitURL&&(g=webkitURL),"undefined"!==typeof navigator&&"undefined"===typeof navigator.getUserMedia&&("undefined"!==typeof navigator.webkitGetUserMedia&&(navigator.getUserMedia=navigator.webkitGetUserMedia),"undefined"!==typeof navigator.mozGetUserMedia&&(navigator.getUserMedia=navigator.mozGetUserMedia));var p=-1!==navigator.userAgent.indexOf("Edge")&&(!!navigator.msSaveBlob||!!navigator.msSaveOrOpenBlob),v=!!window.opera||-1!==navigator.userAgent.indexOf("OPR/"),b=navigator.userAgent.toLowerCase().indexOf("firefox")>-1&&"netscape"in window&&/ rv:/.test(navigator.userAgent),w=!v&&!p&&!!navigator.webkitGetUserMedia||C()||-1!==navigator.userAgent.toLowerCase().indexOf("chrome/"),y=/^((?!chrome|android).)*safari/i.test(navigator.userAgent);y&&!w&&-1!==navigator.userAgent.indexOf("CriOS")&&(y=!1,w=!0);var R=window.MediaStream;function S(e){var t=1e3,i=["Bytes","KB","MB","GB","TB"];if(0===e)return"0 Bytes";var o=parseInt(Math.floor(Math.log(e)/Math.log(t)),10);return(e/Math.pow(t,o)).toPrecision(3)+" "+i[o]}function k(e,t){if(!e)throw"Blob object is required.";if(!e.type)try{e.type="video/webm"}catch(a){}var i=(e.type||"video/webm").split("/")[1];if(t&&-1!==t.indexOf(".")){var o=t.split(".");t=o[0],i=o[1]}var n=(t||Math.round(9999999999*Math.random())+888888888)+"."+i;if("undefined"!==typeof navigator.msSaveOrOpenBlob)return navigator.msSaveOrOpenBlob(e,n);if("undefined"!==typeof navigator.msSaveBlob)return navigator.msSaveBlob(e,n);var r=document.createElement("a");r.href=g.createObjectURL(e),r.download=n,r.style="display:none;opacity:0;color:transparent;",(document.body||document.documentElement).appendChild(r),"function"===typeof r.click?r.click():(r.target="_blank",r.dispatchEvent(new MouseEvent("click",{view:window,bubbles:!0,cancelable:!0}))),g.revokeObjectURL(r.href)}function C(){return"undefined"!==typeof window&&"object"===typeof window.process&&"renderer"===window.process.type||(!("undefined"===typeof o||"object"!==typeof o.versions||!o.versions.electron)||"object"===typeof navigator&&"string"===typeof navigator.userAgent&&navigator.userAgent.indexOf("Electron")>=0)}function T(e,t){return e&&e.getTracks?e.getTracks().filter(function(e){return e.kind===(t||"audio")}):[]}function L(e,t){"srcObject"in t?t.srcObject=e:"mozSrcObject"in t?t.mozSrcObject=e:t.srcObject=e}function M(e,t){if("undefined"===typeof EBML)throw new Error("Please link: https://www.webrtc-experiment.com/EBML.js");var i=new EBML.Reader,o=new EBML.Decoder,n=EBML.tools,r=new FileReader;r.onload=function(e){var r=o.decode(this.result);r.forEach(function(e){i.read(e)}),i.stop();var a=n.makeMetadataSeekable(i.metadatas,i.duration,i.cues),d=this.result.slice(i.metadataSize),s=new Blob([a,d],{type:"video/webm"});t(s)},r.readAsArrayBuffer(e)}"undefined"===typeof R&&"undefined"!==typeof webkitMediaStream&&(R=webkitMediaStream),"undefined"!==typeof R&&"undefined"===typeof R.prototype.stop&&(R.prototype.stop=function(){this.getTracks().forEach(function(e){e.stop()})}),"undefined"!==typeof a&&(a.invokeSaveAsDialog=k,a.getTracks=T,a.getSeekableBlob=M,a.bytesToSize=S,a.isElectron=C);
/**
 * Storage is a standalone object used by {@link RecordRTC} to store reusable objects e.g. "new AudioContext".
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @example
 * Storage.AudioContext === webkitAudioContext
 * @property {webkitAudioContext} AudioContext - Keeps a reference to AudioContext object.
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 */
var A={};function D(){if(b||y||p)return!0;navigator.appVersion;var e,t,i=navigator.userAgent,o=""+parseFloat(navigator.appVersion),n=parseInt(navigator.appVersion,10);return(w||v)&&(e=i.indexOf("Chrome"),o=i.substring(e+7)),-1!==(t=o.indexOf(";"))&&(o=o.substring(0,t)),-1!==(t=o.indexOf(" "))&&(o=o.substring(0,t)),n=parseInt(""+o,10),isNaN(n)&&(o=""+parseFloat(navigator.appVersion),n=parseInt(navigator.appVersion,10)),n>=49}
/**
 * MediaStreamRecorder is an abstraction layer for {@link https://w3c.github.io/mediacapture-record/MediaRecorder.html|MediaRecorder API}. It is used by {@link RecordRTC} to record MediaStream(s) in both Chrome and Firefox.
 * @summary Runs top over {@link https://w3c.github.io/mediacapture-record/MediaRecorder.html|MediaRecorder API}.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://github.com/muaz-khan|Muaz Khan}
 * @typedef MediaStreamRecorder
 * @class
 * @example
 * var config = {
 *     mimeType: 'video/webm', // vp8, vp9, h264, mkv, opus/vorbis
 *     audioBitsPerSecond : 256 * 8 * 1024,
 *     videoBitsPerSecond : 256 * 8 * 1024,
 *     bitsPerSecond: 256 * 8 * 1024,  // if this is provided, skip above two
 *     checkForInactiveTracks: true,
 *     timeSlice: 1000, // concatenate intervals based blobs
 *     ondataavailable: function() {} // get intervals based blobs
 * }
 * var recorder = new MediaStreamRecorder(mediaStream, config);
 * recorder.record();
 * recorder.stop(function(blob) {
 *     video.src = URL.createObjectURL(blob);
 *
 *     // or
 *     var blob = recorder.blob;
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @param {object} config - {disableLogs:true, initCallback: function, mimeType: "video/webm", timeSlice: 1000}
 * @throws Will throw an error if first argument "MediaStream" is missing. Also throws error if "MediaRecorder API" are not supported by the browser.
 */function U(e,t){var i=this;if("undefined"===typeof e)throw'First argument "MediaStream" is required.';if("undefined"===typeof MediaRecorder)throw"Your browser does not support the Media Recorder API. Please try other modules e.g. WhammyRecorder or StereoAudioRecorder.";if(t=t||{mimeType:"video/webm"},"audio"===t.type){var o;if(T(e,"video").length&&T(e,"audio").length)navigator.mozGetUserMedia?(o=new R,o.addTrack(T(e,"audio")[0])):o=new R(T(e,"audio")),e=o;t.mimeType&&-1!==t.mimeType.toString().toLowerCase().indexOf("audio")||(t.mimeType=w?"audio/webm":"audio/ogg"),t.mimeType&&"audio/ogg"!==t.mimeType.toString().toLowerCase()&&navigator.mozGetUserMedia&&(t.mimeType="audio/ogg")}var n,r=[];function a(){i.timestamps.push((new Date).getTime()),"function"===typeof t.onTimeStamp&&t.onTimeStamp(i.timestamps[i.timestamps.length-1],i.timestamps)}function d(e){return n&&n.mimeType?n.mimeType:e.mimeType||"video/webm"}function s(){r=[],n=null,i.timestamps=[]}function c(){if("active"in e){if(!e.active)return!1}else if("ended"in e&&e.ended)return!1;return!0}this.getArrayOfBlobs=function(){return r},this.record=function(){i.blob=null,i.clearRecordedData(),i.timestamps=[],u=[],r=[];var o=t;t.disableLogs||console.log("Passing following config over MediaRecorder API.",o),n&&(n=null),w&&!D()&&(o="video/vp8"),"function"===typeof MediaRecorder.isTypeSupported&&o.mimeType&&(MediaRecorder.isTypeSupported(o.mimeType)||(t.disableLogs||console.warn("MediaRecorder API seems unable to record mimeType:",o.mimeType),o.mimeType="audio"===t.type?"audio/webm":"video/webm"));try{n=new MediaRecorder(e,o),t.mimeType=o.mimeType}catch(s){n=new MediaRecorder(e)}o.mimeType&&!MediaRecorder.isTypeSupported&&"canRecordMimeType"in n&&!1===n.canRecordMimeType(o.mimeType)&&(t.disableLogs||console.warn("MediaRecorder API seems unable to record mimeType:",o.mimeType)),n.ondataavailable=function(e){if(e.data&&u.push("ondataavailable: "+S(e.data.size)),"number"!==typeof t.timeSlice)!e.data||!e.data.size||e.data.size<100||i.blob?i.recordingCallback&&(i.recordingCallback(new Blob([],{type:d(o)})),i.recordingCallback=null):(i.blob=t.getNativeBlob?e.data:new Blob([e.data],{type:d(o)}),i.recordingCallback&&(i.recordingCallback(i.blob),i.recordingCallback=null));else if(e.data&&e.data.size&&e.data.size>100&&(r.push(e.data),a(),"function"===typeof t.ondataavailable)){var n=t.getNativeBlob?e.data:new Blob([e.data],{type:d(o)});t.ondataavailable(n)}},n.onstart=function(){u.push("started")},n.onpause=function(){u.push("paused")},n.onresume=function(){u.push("resumed")},n.onstop=function(){u.push("stopped")},n.onerror=function(e){e&&(e.name||(e.name="UnknownError"),u.push("error: "+e),t.disableLogs||(-1!==e.name.toString().toLowerCase().indexOf("invalidstate")?console.error("The MediaRecorder is not in a state in which the proposed operation is allowed to be executed.",e):-1!==e.name.toString().toLowerCase().indexOf("notsupported")?console.error("MIME type (",o.mimeType,") is not supported.",e):-1!==e.name.toString().toLowerCase().indexOf("security")?console.error("MediaRecorder security error",e):"OutOfMemory"===e.name?console.error("The UA has exhaused the available memory. User agents SHOULD provide as much additional information as possible in the message attribute.",e):"IllegalStreamModification"===e.name?console.error("A modification to the stream has occurred that makes it impossible to continue recording. An example would be the addition of a Track while recording is occurring. User agents SHOULD provide as much additional information as possible in the message attribute.",e):"OtherRecordingError"===e.name?console.error("Used for an fatal error other than those listed above. User agents SHOULD provide as much additional information as possible in the message attribute.",e):"GenericError"===e.name?console.error("The UA cannot provide the codec or recording option that has been requested.",e):console.error("MediaRecorder Error",e)),function(e){if(!i.manuallyStopped&&n&&"inactive"===n.state)return delete t.timeslice,void n.start(6e5);setTimeout(e,1e3)}(),"inactive"!==n.state&&"stopped"!==n.state&&n.stop())},"number"===typeof t.timeSlice?(a(),n.start(t.timeSlice)):n.start(36e5),t.initCallback&&t.initCallback()},this.timestamps=[],this.stop=function(e){e=e||function(){},i.manuallyStopped=!0,n&&(this.recordingCallback=e,"recording"===n.state&&n.stop(),"number"===typeof t.timeSlice&&setTimeout(function(){i.blob=new Blob(r,{type:d(t)}),i.recordingCallback(i.blob)},100))},this.pause=function(){n&&"recording"===n.state&&n.pause()},this.resume=function(){n&&"paused"===n.state&&n.resume()},this.clearRecordedData=function(){n&&"recording"===n.state&&i.stop(s),s()},this.getInternalRecorder=function(){return n},this.blob=null,this.getState=function(){return n&&n.state||"inactive"};var u=[];this.getAllStates=function(){return u},"undefined"===typeof t.checkForInactiveTracks&&(t.checkForInactiveTracks=!1);i=this;(function e(){if(n&&!1!==t.checkForInactiveTracks)return!1===c()?(t.disableLogs||console.log("MediaStream seems stopped."),void i.stop()):void setTimeout(e,1e3)})(),this.name="MediaStreamRecorder",this.toString=function(){return this.name}}
/**
 * StereoAudioRecorder is a standalone class used by {@link RecordRTC} to bring "stereo" audio-recording in chrome.
 * @summary JavaScript standalone object for stereo audio recording.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef StereoAudioRecorder
 * @class
 * @example
 * var recorder = new StereoAudioRecorder(MediaStream, {
 *     sampleRate: 44100,
 *     bufferSize: 4096
 * });
 * recorder.record();
 * recorder.stop(function(blob) {
 *     video.src = URL.createObjectURL(blob);
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @param {object} config - {sampleRate: 44100, bufferSize: 4096, numberOfAudioChannels: 1, etc.}
 */
function x(e,t){if(!T(e,"audio").length)throw"Your stream has no audio tracks.";t=t||{};var i,o=this,n=[],r=[],d=!1,s=0,c=2,u=t.desiredSampRate;function f(){if(!1===t.checkForInactiveTracks)return!0;if("active"in e){if(!e.active)return!1}else if("ended"in e&&e.ended)return!1;return!0}function l(e,t){function i(e,t){var i,o=e.numberOfAudioChannels,n=e.leftBuffers.slice(0),r=e.rightBuffers.slice(0),a=e.sampleRate,d=e.internalInterleavedLength,s=e.desiredSampRate;function c(e,t,i){var o=Math.round(e.length*(t/i)),n=[],r=Number((e.length-1)/(o-1));n[0]=e[0];for(var a=1;a<o-1;a++){var d=a*r,s=Number(Math.floor(d)).toFixed(),c=Number(Math.ceil(d)).toFixed(),f=d-s;n[a]=u(e[s],e[c],f)}return n[o-1]=e[e.length-1],n}function u(e,t,i){return e+(t-e)*i}function f(e,t){for(var i=new Float64Array(t),o=0,n=e.length,r=0;r<n;r++){var a=e[r];i.set(a,o),o+=a.length}return i}function l(e,t){for(var i=e.length+t.length,o=new Float64Array(i),n=0,r=0;r<i;)o[r++]=e[n],o[r++]=t[n],n++;return o}function h(e,t,i){for(var o=i.length,n=0;n<o;n++)e.setUint8(t+n,i.charCodeAt(n))}2===o&&(n=f(n,d),r=f(r,d),s&&(n=c(n,s,a),r=c(r,s,a))),1===o&&(n=f(n,d),s&&(n=c(n,s,a))),s&&(a=s),2===o&&(i=l(n,r)),1===o&&(i=n);var m=i.length,g=44+2*m,p=new ArrayBuffer(g),v=new DataView(p);h(v,0,"RIFF"),v.setUint32(4,36+2*m,!0),h(v,8,"WAVE"),h(v,12,"fmt "),v.setUint32(16,16,!0),v.setUint16(20,1,!0),v.setUint16(22,o,!0),v.setUint32(24,a,!0),v.setUint32(28,2*a,!0),v.setUint16(32,2*o,!0),v.setUint16(34,16,!0),h(v,36,"data"),v.setUint32(40,2*m,!0);for(var b=m,w=44,y=1,R=0;R<b;R++)v.setInt16(w,i[R]*(32767*y),!0),w+=2;if(t)return t({buffer:p,view:v});postMessage({buffer:p,view:v})}if(e.noWorker)i(e,function(e){t(e.buffer,e.view)});else{var o=h(i);o.onmessage=function(e){t(e.data.buffer,e.data.view),g.revokeObjectURL(o.workerURL),o.terminate()},o.postMessage(e)}}function h(e){var t=g.createObjectURL(new Blob([e.toString(),";this.onmessage =  function (eee) {"+e.name+"(eee.data);}"],{type:"application/javascript"})),i=new Worker(t);return i.workerURL=t,i}!0===t.leftChannel&&(c=1),1===t.numberOfAudioChannels&&(c=1),(!c||c<1)&&(c=2),t.disableLogs||console.log("StereoAudioRecorder is set to record number of channels: "+c),"undefined"===typeof t.checkForInactiveTracks&&(t.checkForInactiveTracks=!0),this.record=function(){if(!1===f())throw"Please make sure MediaStream is active.";R(),k=y=!1,d=!0,"undefined"!==typeof t.timeSlice&&M()},this.stop=function(e){e=e||function(){},d=!1,l({desiredSampRate:u,sampleRate:w,numberOfAudioChannels:c,internalInterleavedLength:s,leftBuffers:n,rightBuffers:1===c?[]:r,noWorker:t.noWorker},function(t,i){o.blob=new Blob([i],{type:"audio/wav"}),o.buffer=new ArrayBuffer(i.buffer.byteLength),o.view=i,o.sampleRate=u||w,o.bufferSize=b,o.length=s,k=!1,e&&e(o.blob)})},"undefined"===typeof a.Storage&&(a.Storage={AudioContextConstructor:null,AudioContext:window.AudioContext||window.webkitAudioContext}),a.Storage.AudioContextConstructor&&"closed"!==a.Storage.AudioContextConstructor.state||(a.Storage.AudioContextConstructor=new a.Storage.AudioContext);var m=a.Storage.AudioContextConstructor,p=m.createMediaStreamSource(e),v=[0,256,512,1024,2048,4096,8192,16384],b="undefined"===typeof t.bufferSize?4096:t.bufferSize;if(-1===v.indexOf(b)&&(t.disableLogs||console.log("Legal values for buffer-size are "+JSON.stringify(v,null,"\t"))),m.createJavaScriptNode)i=m.createJavaScriptNode(b,c,c);else{if(!m.createScriptProcessor)throw"WebAudio API has no support on this browser.";i=m.createScriptProcessor(b,c,c)}p.connect(i),t.bufferSize||(b=i.bufferSize);var w="undefined"!==typeof t.sampleRate?t.sampleRate:m.sampleRate||44100;(w<22050||w>96e3)&&(t.disableLogs||console.log("sample-rate must be under range 22050 and 96000.")),t.disableLogs||t.desiredSampRate&&console.log("Desired sample-rate: "+t.desiredSampRate);var y=!1;function R(){n=[],r=[],s=0,k=!1,d=!1,y=!1,m=null,o.leftchannel=n,o.rightchannel=r,o.numberOfAudioChannels=c,o.desiredSampRate=u,o.sampleRate=w,o.recordingLength=s,L={left:[],right:[],recordingLength:0}}function S(){i&&(i.onaudioprocess=null,i.disconnect(),i=null),p&&(p.disconnect(),p=null),R()}this.pause=function(){y=!0},this.resume=function(){if(!1===f())throw"Please make sure MediaStream is active.";if(!d)return t.disableLogs||console.log("Seems recording has been restarted."),void this.record();y=!1},this.clearRecordedData=function(){t.checkForInactiveTracks=!1,d&&this.stop(S),S()},this.name="StereoAudioRecorder",this.toString=function(){return this.name};var k=!1;function C(e){if(!y)if(!1===f()&&(t.disableLogs||console.log("MediaStream seems stopped."),i.disconnect(),d=!1),d){k||(k=!0,t.onAudioProcessStarted&&t.onAudioProcessStarted(),t.initCallback&&t.initCallback());var a=e.inputBuffer.getChannelData(0),u=new Float32Array(a);if(n.push(u),2===c){var l=e.inputBuffer.getChannelData(1),h=new Float32Array(l);r.push(h)}s+=b,o.recordingLength=s,"undefined"!==typeof t.timeSlice&&(L.recordingLength+=b,L.left.push(u),2===c&&L.right.push(h))}else p&&(p.disconnect(),p=null)}i.onaudioprocess=C,m.createMediaStreamDestination?i.connect(m.createMediaStreamDestination()):i.connect(m.destination),this.leftchannel=n,this.rightchannel=r,this.numberOfAudioChannels=c,this.desiredSampRate=u,this.sampleRate=w,o.recordingLength=s;var L={left:[],right:[],recordingLength:0};function M(){d&&"function"===typeof t.ondataavailable&&"undefined"!==typeof t.timeSlice&&(L.left.length?(l({desiredSampRate:u,sampleRate:w,numberOfAudioChannels:c,internalInterleavedLength:L.recordingLength,leftBuffers:L.left,rightBuffers:1===c?[]:L.right},function(e,i){var o=new Blob([i],{type:"audio/wav"});t.ondataavailable(o),setTimeout(M,t.timeSlice)}),L={left:[],right:[],recordingLength:0}):setTimeout(M,t.timeSlice))}}
/**
 * CanvasRecorder is a standalone class used by {@link RecordRTC} to bring HTML5-Canvas recording into video WebM. It uses HTML2Canvas library and runs top over {@link Whammy}.
 * @summary HTML2Canvas recording into video WebM.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef CanvasRecorder
 * @class
 * @example
 * var recorder = new CanvasRecorder(htmlElement, { disableLogs: true, useWhammyRecorder: true });
 * recorder.record();
 * recorder.stop(function(blob) {
 *     video.src = URL.createObjectURL(blob);
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {HTMLElement} htmlElement - querySelector/getElementById/getElementsByTagName[0]/etc.
 * @param {object} config - {disableLogs:true, initCallback: function}
 */
function B(e,t){if("undefined"===typeof html2canvas)throw"Please link: https://www.webrtc-experiment.com/screenshot.js";t=t||{},t.frameInterval||(t.frameInterval=10);var i=!1;["captureStream","mozCaptureStream","webkitCaptureStream"].forEach(function(e){e in document.createElement("canvas")&&(i=!0)});var o,n,r,a=(!!window.webkitRTCPeerConnection||!!window.webkitGetUserMedia)&&!!window.chrome,d=50,s=navigator.userAgent.match(/Chrom(e|ium)\/([0-9]+)\./);if(a&&s&&s[2]&&(d=parseInt(s[2],10)),a&&d<52&&(i=!1),t.useWhammyRecorder&&(i=!1),i)if(t.disableLogs||console.log("Your browser supports both MediRecorder API and canvas.captureStream!"),e instanceof HTMLCanvasElement)o=e;else{if(!(e instanceof CanvasRenderingContext2D))throw"Please pass either HTMLCanvasElement or CanvasRenderingContext2D.";o=e.canvas}else navigator.mozGetUserMedia&&(t.disableLogs||console.error("Canvas recording is NOT supported in Firefox."));this.record=function(){if(r=!0,i&&!t.useWhammyRecorder){var e;"captureStream"in o?e=o.captureStream(25):"mozCaptureStream"in o?e=o.mozCaptureStream(25):"webkitCaptureStream"in o&&(e=o.webkitCaptureStream(25));try{var a=new R;a.addTrack(T(e,"video")[0]),e=a}catch(d){}if(!e)throw"captureStream API are NOT available.";n=new U(e,{mimeType:t.mimeType||"video/webm"}),n.record()}else m.frames=[],h=(new Date).getTime(),l();t.initCallback&&t.initCallback()},this.getWebPImages=function(i){if("canvas"===e.nodeName.toLowerCase()){var o=m.frames.length;m.frames.forEach(function(e,i){var n=o-i;t.disableLogs||console.log(n+"/"+o+" frames remaining"),t.onEncodingCallback&&t.onEncodingCallback(n,o);var r=e.image.toDataURL("image/webp",1);m.frames[i].image=r}),t.disableLogs||console.log("Generating WebM"),i()}else i()},this.stop=function(e){r=!1;var o=this;i&&n?n.stop(e):this.getWebPImages(function(){m.compile(function(i){t.disableLogs||console.log("Recording finished!"),o.blob=i,o.blob.forEach&&(o.blob=new Blob([],{type:"video/webm"})),e&&e(o.blob),m.frames=[]})})};var c=!1;function u(){m.frames=[],r=!1,c=!1}function f(){var t=document.createElement("canvas"),i=t.getContext("2d");return t.width=e.width,t.height=e.height,i.drawImage(e,0,0),t}function l(){if(c)return h=(new Date).getTime(),setTimeout(l,500);if("canvas"===e.nodeName.toLowerCase()){var i=(new Date).getTime()-h;return h=(new Date).getTime(),m.frames.push({image:f(),duration:i}),void(r&&setTimeout(l,t.frameInterval))}html2canvas(e,{grabMouse:"undefined"===typeof t.showMousePointer||t.showMousePointer,onrendered:function(e){var i=(new Date).getTime()-h;if(!i)return setTimeout(l,t.frameInterval);h=(new Date).getTime(),m.frames.push({image:e.toDataURL("image/webp",1),duration:i}),r&&setTimeout(l,t.frameInterval)}})}this.pause=function(){c=!0,n instanceof U&&n.pause()},this.resume=function(){c=!1,n instanceof U?n.resume():r||this.record()},this.clearRecordedData=function(){r&&this.stop(u),u()},this.name="CanvasRecorder",this.toString=function(){return this.name};var h=(new Date).getTime(),m=new I.Video(100)}
/**
 * WhammyRecorder is a standalone class used by {@link RecordRTC} to bring video recording in Chrome. It runs top over {@link Whammy}.
 * @summary Video recording feature in Chrome.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef WhammyRecorder
 * @class
 * @example
 * var recorder = new WhammyRecorder(mediaStream);
 * recorder.record();
 * recorder.stop(function(blob) {
 *     video.src = URL.createObjectURL(blob);
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @param {object} config - {disableLogs: true, initCallback: function, video: HTMLVideoElement, etc.}
 */
function E(e,t){function i(e){e="undefined"!==typeof e?e:10;var t=(new Date).getTime()-c;return t?a?(c=(new Date).getTime(),setTimeout(i,100)):(c=(new Date).getTime(),s.paused&&s.play(),l.drawImage(s,0,0,f.width,f.height),u.frames.push({duration:t,image:f.toDataURL("image/webp")}),void(r||setTimeout(i,e,e))):setTimeout(i,e,e)}function o(e){var t=-1,i=e.length;(function o(){t++,t!==i?setTimeout(function(){e.functionToLoop(o,t)},1):e.callback()})()}function n(e,t,i,n,r){var a=document.createElement("canvas");a.width=f.width,a.height=f.height;var d=a.getContext("2d"),s=[],c=-1===t,u=t&&t>0&&t<=e.length?t:e.length,l={r:0,g:0,b:0},h=Math.sqrt(Math.pow(255,2)+Math.pow(255,2)+Math.pow(255,2)),m=i&&i>=0&&i<=1?i:0,g=n&&n>=0&&n<=1?n:0,p=!1;o({length:u,functionToLoop:function(t,i){var o,n,r,a=function(){!p&&r-o<=r*g||(c&&(p=!0),s.push(e[i])),t()};if(p)a();else{var u=new Image;u.onload=function(){d.drawImage(u,0,0,f.width,f.height);var e=d.getImageData(0,0,f.width,f.height);o=0,n=e.data.length,r=e.data.length/4;for(var t=0;t<n;t+=4){var i={r:e.data[t],g:e.data[t+1],b:e.data[t+2]},s=Math.sqrt(Math.pow(i.r-l.r,2)+Math.pow(i.g-l.g,2)+Math.pow(i.b-l.b,2));s<=h*m&&o++}a()},u.src=e[i].image}},callback:function(){s=s.concat(e.slice(u)),s.length<=0&&s.push(e[e.length-1]),r(s)}})}t=t||{},t.frameInterval||(t.frameInterval=10),t.disableLogs||console.log("Using frames-interval:",t.frameInterval),this.record=function(){t.width||(t.width=320),t.height||(t.height=240),t.video||(t.video={width:t.width,height:t.height}),t.canvas||(t.canvas={width:t.width,height:t.height}),f.width=t.canvas.width||320,f.height=t.canvas.height||240,l=f.getContext("2d"),t.video&&t.video instanceof HTMLVideoElement?(s=t.video.cloneNode(),t.initCallback&&t.initCallback()):(s=document.createElement("video"),L(e,s),s.onloadedmetadata=function(){t.initCallback&&t.initCallback()},s.width=t.video.width,s.height=t.video.height),s.muted=!0,s.play(),c=(new Date).getTime(),u=new I.Video,t.disableLogs||(console.log("canvas resolutions",f.width,"*",f.height),console.log("video width/height",s.width||f.width,"*",s.height||f.height)),i(t.frameInterval)};var r=!1;this.stop=function(e){e=e||function(){},r=!0;var i=this;setTimeout(function(){n(u.frames,-1,null,null,function(o){u.frames=o,t.advertisement&&t.advertisement.length&&(u.frames=t.advertisement.concat(u.frames)),u.compile(function(t){i.blob=t,i.blob.forEach&&(i.blob=new Blob([],{type:"video/webm"})),e&&e(i.blob)})})},10)};var a=!1;function d(){u.frames=[],r=!0,a=!1}this.pause=function(){a=!0},this.resume=function(){a=!1,r&&this.record()},this.clearRecordedData=function(){r||this.stop(d),d()},this.name="WhammyRecorder",this.toString=function(){return this.name};var s,c,u,f=document.createElement("canvas"),l=f.getContext("2d")}"undefined"!==typeof m?A.AudioContext=m:"undefined"!==typeof webkitAudioContext&&(A.AudioContext=webkitAudioContext),"undefined"!==typeof a&&(a.Storage=A),"undefined"!==typeof a&&(a.MediaStreamRecorder=U),"undefined"!==typeof a&&(a.StereoAudioRecorder=x),"undefined"!==typeof a&&(a.CanvasRecorder=B),"undefined"!==typeof a&&(a.WhammyRecorder=E);
/**
 * Whammy is a standalone class used by {@link RecordRTC} to bring video recording in Chrome. It is written by {@link https://github.com/antimatter15|antimatter15}
 * @summary A real time javascript webm encoder based on a canvas hack.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef Whammy
 * @class
 * @example
 * var recorder = new Whammy().Video(15);
 * recorder.add(context || canvas || dataURL);
 * var output = recorder.compile();
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 */
var I=function(){function e(e){this.frames=[],this.duration=e||1,this.quality=.8}function t(e){var t=g.createObjectURL(new Blob([e.toString(),"this.onmessage =  function (eee) {"+e.name+"(eee.data);}"],{type:"application/javascript"})),i=new Worker(t);return g.revokeObjectURL(t),i}function i(e){function t(e){var t=o(e);if(!t)return[];var n=3e4,r=[{id:440786851,data:[{data:1,id:17030},{data:1,id:17143},{data:4,id:17138},{data:8,id:17139},{data:"webm",id:17026},{data:2,id:17031},{data:2,id:17029}]},{id:408125543,data:[{id:357149030,data:[{data:1e6,id:2807729},{data:"whammy",id:19840},{data:"whammy",id:22337},{data:l(t.duration),id:17545}]},{id:374648427,data:[{id:174,data:[{data:1,id:215},{data:1,id:29637},{data:0,id:156},{data:"und",id:2274716},{data:"V_VP8",id:134},{data:"VP8",id:2459272},{data:1,id:131},{id:224,data:[{data:t.width,id:176},{data:t.height,id:186}]}]}]}]}],a=0,s=0;while(a<e.length){var c=[],u=0;do{c.push(e[a]),u+=e[a].duration,a++}while(a<e.length&&u<n);var f=0,h={id:524531317,data:i(s,f,c)};r[1].data.push(h),s+=u}return d(r)}function i(e,t,i){return[{data:e,id:231}].concat(i.map(function(e){var i=s({discardable:0,frame:e.data.slice(4),invisible:0,keyframe:1,lacing:0,trackNum:1,timecode:Math.round(t)});return t+=e.duration,{data:i,id:163}}))}function o(e){if(e[0]){for(var t=e[0].width,i=e[0].height,o=e[0].duration,n=1;n<e.length;n++)o+=e[n].duration;return{duration:o,width:t,height:i}}postMessage({error:"Something went wrong. Maybe WebP format is not supported in the current browser."})}function n(e){var t=[];while(e>0)t.push(255&e),e>>=8;return new Uint8Array(t.reverse())}function r(e){return new Uint8Array(e.split("").map(function(e){return e.charCodeAt(0)}))}function a(e){var t=[],i=e.length%8?new Array(9-e.length%8).join("0"):"";e=i+e;for(var o=0;o<e.length;o+=8)t.push(parseInt(e.substr(o,8),2));return new Uint8Array(t)}function d(e){for(var t=[],i=0;i<e.length;i++){var o=e[i].data;"object"===typeof o&&(o=d(o)),"number"===typeof o&&(o=a(o.toString(2))),"string"===typeof o&&(o=r(o));var s=o.size||o.byteLength||o.length,c=Math.ceil(Math.ceil(Math.log(s)/Math.log(2))/8),u=s.toString(2),f=new Array(7*c+7+1-u.length).join("0")+u,l=new Array(c).join("0")+"1"+f;t.push(n(e[i].id)),t.push(a(l)),t.push(o)}return new Blob(t,{type:"video/webm"})}function s(e){var t=0;if(e.keyframe&&(t|=128),e.invisible&&(t|=8),e.lacing&&(t|=e.lacing<<1),e.discardable&&(t|=1),e.trackNum>127)throw"TrackNumber > 127 not supported";var i=[128|e.trackNum,e.timecode>>8,255&e.timecode,t].map(function(e){return String.fromCharCode(e)}).join("")+e.frame;return i}function c(e){for(var t,i,o,n=e.RIFF[0].WEBP[0],r=n.indexOf("*"),a=0,d=[];a<4;a++)d[a]=n.charCodeAt(r+3+a);return o=d[1]<<8|d[0],t=16383&o,o=d[3]<<8|d[2],i=16383&o,{width:t,height:i,data:n,riff:e}}function u(e,t){return parseInt(e.substr(t+4,4).split("").map(function(e){var t=e.charCodeAt(0).toString(2);return new Array(8-t.length+1).join("0")+t}).join(""),2)}function f(e){var t=0,i={};while(t<e.length){var o=e.substr(t,4),n=u(e,t),r=e.substr(t+4+4,n);t+=8+n,i[o]=i[o]||[],"RIFF"===o||"LIST"===o?i[o].push(f(r)):i[o].push(r)}return i}function l(e){return[].slice.call(new Uint8Array(new Float64Array([e]).buffer),0).map(function(e){return String.fromCharCode(e)}).reverse().join("")}var h=new t(e.map(function(e){var t=c(f(atob(e.image.slice(23))));return t.duration=e.duration,t}));postMessage(h)}return e.prototype.add=function(e,t){if("canvas"in e&&(e=e.canvas),"toDataURL"in e&&(e=e.toDataURL("image/webp",this.quality)),!/^data:image\/webp;base64,/gi.test(e))throw"Input must be formatted properly as a base64 encoded DataURI of type image/webp";this.frames.push({image:e,duration:t||this.duration})},e.prototype.compile=function(e){var o=t(i);o.onmessage=function(t){t.data.error?console.error(t.data.error):e(t.data)},o.postMessage(this.frames)},{Video:e}}();"undefined"!==typeof a&&(a.Whammy=I);
/**
 * DiskStorage is a standalone object used by {@link RecordRTC} to store recorded blobs in IndexedDB storage.
 * @summary Writing blobs into IndexedDB.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @example
 * DiskStorage.Store({
 *     audioBlob: yourAudioBlob,
 *     videoBlob: yourVideoBlob,
 *     gifBlob  : yourGifBlob
 * });
 * DiskStorage.Fetch(function(dataURL, type) {
 *     if(type === 'audioBlob') { }
 *     if(type === 'videoBlob') { }
 *     if(type === 'gifBlob')   { }
 * });
 * // DiskStorage.dataStoreName = 'recordRTC';
 * // DiskStorage.onError = function(error) { };
 * @property {function} init - This method must be called once to initialize IndexedDB ObjectStore. Though, it is auto-used internally.
 * @property {function} Fetch - This method fetches stored blobs from IndexedDB.
 * @property {function} Store - This method stores blobs in IndexedDB.
 * @property {function} onError - This function is invoked for any known/unknown error.
 * @property {string} dataStoreName - Name of the ObjectStore created in IndexedDB storage.
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 */var O={init:function(){var e=this;if("undefined"!==typeof indexedDB&&"undefined"!==typeof indexedDB.open){var t,i=1,o=this.dbName||location.href.replace(/\/|:|#|%|\.|\[|\]/g,""),n=indexedDB.open(o,i);n.onerror=e.onError,n.onsuccess=function(){if(t=n.result,t.onerror=e.onError,t.setVersion)if(t.version!==i){var o=t.setVersion(i);o.onsuccess=function(){r(t),a()}}else a();else a()},n.onupgradeneeded=function(e){r(e.target.result)}}else console.error("IndexedDB API are not available in this browser.");function r(t){t.createObjectStore(e.dataStoreName)}function a(){var i=t.transaction([e.dataStoreName],"readwrite");function o(t){i.objectStore(e.dataStoreName).get(t).onsuccess=function(i){e.callback&&e.callback(i.target.result,t)}}e.videoBlob&&i.objectStore(e.dataStoreName).put(e.videoBlob,"videoBlob"),e.gifBlob&&i.objectStore(e.dataStoreName).put(e.gifBlob,"gifBlob"),e.audioBlob&&i.objectStore(e.dataStoreName).put(e.audioBlob,"audioBlob"),o("audioBlob"),o("videoBlob"),o("gifBlob")}},Fetch:function(e){return this.callback=e,this.init(),this},Store:function(e){return this.audioBlob=e.audioBlob,this.videoBlob=e.videoBlob,this.gifBlob=e.gifBlob,this.init(),this},onError:function(e){console.error(JSON.stringify(e,null,"\t"))},dataStoreName:"recordRTC",dbName:null};
/**
 * GifRecorder is standalone calss used by {@link RecordRTC} to record video or canvas into animated gif.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef GifRecorder
 * @class
 * @example
 * var recorder = new GifRecorder(mediaStream || canvas || context, { onGifPreview: function, onGifRecordingStarted: function, width: 1280, height: 720, frameRate: 200, quality: 10 });
 * recorder.record();
 * recorder.stop(function(blob) {
 *     img.src = URL.createObjectURL(blob);
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object or HTMLCanvasElement or CanvasRenderingContext2D.
 * @param {object} config - {disableLogs:true, initCallback: function, width: 320, height: 240, frameRate: 200, quality: 10}
 */
function F(e,t){if("undefined"===typeof GIFEncoder){var i=document.createElement("script");i.src="https://www.webrtc-experiment.com/gif-recorder.js",(document.body||document.documentElement).appendChild(i)}t=t||{};var o=e instanceof CanvasRenderingContext2D||e instanceof HTMLCanvasElement;this.record=function(){function e(i){if(!0!==g.clearedRecordedData){if(n)return setTimeout(function(){e(i)},100);m=f(e),void 0===typeof u&&(u=i),i-u<90||(!o&&c.paused&&c.play(),o||d.drawImage(c,0,0,a.width,a.height),t.onGifPreview&&t.onGifPreview(a.toDataURL("image/png")),l.addFrame(d),u=i)}}"undefined"!==typeof GIFEncoder&&s?(o||(t.width||(t.width=c.offsetWidth||320),t.height||(t.height=c.offsetHeight||240),t.video||(t.video={width:t.width,height:t.height}),t.canvas||(t.canvas={width:t.width,height:t.height}),a.width=t.canvas.width||320,a.height=t.canvas.height||240,c.width=t.video.width||320,c.height=t.video.height||240),l=new GIFEncoder,l.setRepeat(0),l.setDelay(t.frameRate||200),l.setQuality(t.quality||10),l.start(),"function"===typeof t.onGifRecordingStarted&&t.onGifRecordingStarted(),Date.now(),m=f(e),t.initCallback&&t.initCallback()):setTimeout(g.record,1e3)},this.stop=function(e){e=e||function(){},m&&h(m),Date.now(),this.blob=new Blob([new Uint8Array(l.stream().bin)],{type:"image/gif"}),e(this.blob),l.stream().bin=[]};var n=!1;function r(){l&&(l.stream().bin=[])}this.pause=function(){n=!0},this.resume=function(){n=!1},this.clearRecordedData=function(){g.clearedRecordedData=!0,r()},this.name="GifRecorder",this.toString=function(){return this.name};var a=document.createElement("canvas"),d=a.getContext("2d");o&&(e instanceof CanvasRenderingContext2D?(d=e,a=d.canvas):e instanceof HTMLCanvasElement&&(d=e.getContext("2d"),a=e));var s=!0;if(!o){var c=document.createElement("video");c.muted=!0,c.autoplay=!0,c.playsInline=!0,s=!1,c.onloadedmetadata=function(){s=!0},L(e,c),c.play()}var u,l,m=null,g=this}function P(e,t){var o="Fake/5.0 (FakeOS) AppleWebKit/123 (KHTML, like Gecko) Fake/12.3.4567.89 Fake/123.45";(function(e){"undefined"===typeof a&&e&&"undefined"===typeof window&&"undefined"!==typeof i&&(i.navigator={userAgent:o,getUserMedia:function(){}},i.console||(i.console={}),"undefined"!==typeof i.console.log&&"undefined"!==typeof i.console.error||(i.console.error=i.console.log=i.console.log||function(){console.log(arguments)}),"undefined"===typeof document&&(e.document={documentElement:{appendChild:function(){return""}}},document.createElement=document.captureStream=document.mozCaptureStream=function(){var e={getContext:function(){return e},play:function(){},pause:function(){},drawImage:function(){},toDataURL:function(){return""},style:{}};return e},e.HTMLVideoElement=function(){}),"undefined"===typeof location&&(e.location={protocol:"file:",href:"",hash:""}),"undefined"===typeof screen&&(e.screen={width:0,height:0}),"undefined"===typeof f&&(e.URL={createObjectURL:function(){return""},revokeObjectURL:function(){return""}}),e.window=i)})("undefined"!==typeof i?i:null),t=t||"multi-streams-mixer";var n=[],r=!1,d=document.createElement("canvas"),s=d.getContext("2d");d.style.opacity=0,d.style.position="absolute",d.style.zIndex=-1,d.style.top="-1000em",d.style.left="-1000em",d.className=t,(document.body||document.documentElement).appendChild(d),this.disableLogs=!1,this.frameInterval=10,this.width=360,this.height=240,this.useGainNode=!0;var c=this,u=window.AudioContext;"undefined"===typeof u&&("undefined"!==typeof webkitAudioContext&&(u=webkitAudioContext),"undefined"!==typeof mozAudioContext&&(u=mozAudioContext));var f=window.URL;"undefined"===typeof f&&"undefined"!==typeof webkitURL&&(f=webkitURL),"undefined"!==typeof navigator&&"undefined"===typeof navigator.getUserMedia&&("undefined"!==typeof navigator.webkitGetUserMedia&&(navigator.getUserMedia=navigator.webkitGetUserMedia),"undefined"!==typeof navigator.mozGetUserMedia&&(navigator.getUserMedia=navigator.mozGetUserMedia));var l=window.MediaStream;"undefined"===typeof l&&"undefined"!==typeof webkitMediaStream&&(l=webkitMediaStream),"undefined"!==typeof l&&"undefined"===typeof l.prototype.stop&&(l.prototype.stop=function(){this.getTracks().forEach(function(e){e.stop()})});var h={};function m(e,t){"srcObject"in t?t.srcObject=e:"mozSrcObject"in t?t.mozSrcObject=e:t.srcObject=e}function g(){if(!r){var e=n.length,t=!1,i=[];if(n.forEach(function(e){e.stream||(e.stream={}),e.stream.fullcanvas?t=e:i.push(e)}),t)d.width=t.stream.width,d.height=t.stream.height;else if(i.length){d.width=e>1?2*i[0].width:i[0].width;var o=1;3!==e&&4!==e||(o=2),5!==e&&6!==e||(o=3),7!==e&&8!==e||(o=4),9!==e&&10!==e||(o=5),d.height=i[0].height*o}else d.width=c.width||360,d.height=c.height||240;t&&t instanceof HTMLVideoElement&&p(t),i.forEach(function(e,t){p(e,t)}),setTimeout(g,c.frameInterval)}}function p(e,t){if(!r){var i=0,o=0,n=e.width,a=e.height;1===t&&(i=e.width),2===t&&(o=e.height),3===t&&(i=e.width,o=e.height),4===t&&(o=2*e.height),5===t&&(i=e.width,o=2*e.height),6===t&&(o=3*e.height),7===t&&(i=e.width,o=3*e.height),"undefined"!==typeof e.stream.left&&(i=e.stream.left),"undefined"!==typeof e.stream.top&&(o=e.stream.top),"undefined"!==typeof e.stream.width&&(n=e.stream.width),"undefined"!==typeof e.stream.height&&(a=e.stream.height),s.drawImage(e,i,o,n,a),"function"===typeof e.stream.onRender&&e.stream.onRender(s,i,o,n,a,t)}}function v(){r=!1;var t=b(),i=w();return i&&i.getTracks().filter(function(e){return"audio"===e.kind}).forEach(function(e){t.addTrack(e)}),e.forEach(function(e){e.fullcanvas&&!0}),t}function b(){var e;R(),"captureStream"in d?e=d.captureStream():"mozCaptureStream"in d?e=d.mozCaptureStream():c.disableLogs||console.error("Upgrade to latest Chrome or otherwise enable this flag: chrome://flags/#enable-experimental-web-platform-features");var t=new l;return e.getTracks().filter(function(e){return"video"===e.kind}).forEach(function(e){t.addTrack(e)}),d.stream=t,t}function w(){h.AudioContextConstructor||(h.AudioContextConstructor=new h.AudioContext),c.audioContext=h.AudioContextConstructor,c.audioSources=[],!0===c.useGainNode&&(c.gainNode=c.audioContext.createGain(),c.gainNode.connect(c.audioContext.destination),c.gainNode.gain.value=0);var t=0;if(e.forEach(function(e){if(e.getTracks().filter(function(e){return"audio"===e.kind}).length){t++;var i=c.audioContext.createMediaStreamSource(e);!0===c.useGainNode&&i.connect(c.gainNode),c.audioSources.push(i)}}),t)return c.audioDestination=c.audioContext.createMediaStreamDestination(),c.audioSources.forEach(function(e){e.connect(c.audioDestination)}),c.audioDestination.stream}function y(e){var i=document.createElement("video");return m(e,i),i.className=t,i.muted=!0,i.volume=0,i.width=e.width||c.width||360,i.height=e.height||c.height||240,i.play(),i}function R(t){n=[],t=t||e,t.forEach(function(e){if(e.getTracks().filter(function(e){return"video"===e.kind}).length){var t=y(e);t.stream=e,n.push(t)}})}"undefined"!==typeof u?h.AudioContext=u:"undefined"!==typeof webkitAudioContext&&(h.AudioContext=webkitAudioContext),this.startDrawingFrames=function(){g()},this.appendStreams=function(t){if(!t)throw"First parameter is required.";t instanceof Array||(t=[t]),t.forEach(function(t){var i=new l;if(t.getTracks().filter(function(e){return"video"===e.kind}).length){var o=y(t);o.stream=t,n.push(o),i.addTrack(t.getTracks().filter(function(e){return"video"===e.kind})[0])}if(t.getTracks().filter(function(e){return"audio"===e.kind}).length){var r=c.audioContext.createMediaStreamSource(t);c.audioDestination=c.audioContext.createMediaStreamDestination(),r.connect(c.audioDestination),i.addTrack(c.audioDestination.stream.getTracks().filter(function(e){return"audio"===e.kind})[0])}e.push(i)})},this.releaseStreams=function(){n=[],r=!0,c.gainNode&&(c.gainNode.disconnect(),c.gainNode=null),c.audioSources.length&&(c.audioSources.forEach(function(e){e.disconnect()}),c.audioSources=[]),c.audioDestination&&(c.audioDestination.disconnect(),c.audioDestination=null),c.audioContext&&c.audioContext.close(),c.audioContext=null,s.clearRect(0,0,d.width,d.height),d.stream&&(d.stream.stop(),d.stream=null)},this.resetVideoStreams=function(e){!e||e instanceof Array||(e=[e]),R(e)},this.name="MultiStreamsMixer",this.toString=function(){return this.name},this.getMixedStream=v}
/**
 * MultiStreamRecorder can record multiple videos in single container.
 * @summary Multi-videos recorder.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef MultiStreamRecorder
 * @class
 * @example
 * var options = {
 *     mimeType: 'video/webm'
 * }
 * var recorder = new MultiStreamRecorder(ArrayOfMediaStreams, options);
 * recorder.record();
 * recorder.stop(function(blob) {
 *     video.src = URL.createObjectURL(blob);
 *
 *     // or
 *     var blob = recorder.blob;
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStreams} mediaStreams - Array of MediaStreams.
 * @param {object} config - {disableLogs:true, frameInterval: 1, mimeType: "video/webm"}
 */
function j(e,t){e=e||[];var i,o,n=this;function r(){var t=[];return e.forEach(function(e){T(e,"video").forEach(function(e){t.push(e)})}),t}t=t||{elementClass:"multi-streams-mixer",mimeType:"video/webm",video:{width:360,height:240}},t.frameInterval||(t.frameInterval=10),t.video||(t.video={}),t.video.width||(t.video.width=360),t.video.height||(t.video.height=240),this.record=function(){i=new P(e,t.elementClass||"multi-streams-mixer"),r().length&&(i.frameInterval=t.frameInterval||10,i.width=t.video.width||360,i.height=t.video.height||240,i.startDrawingFrames()),t.previewStream&&"function"===typeof t.previewStream&&t.previewStream(i.getMixedStream()),o=new U(i.getMixedStream(),t),o.record()},this.stop=function(e){o&&o.stop(function(t){n.blob=t,e(t),n.clearRecordedData()})},this.pause=function(){o&&o.pause()},this.resume=function(){o&&o.resume()},this.clearRecordedData=function(){o&&(o.clearRecordedData(),o=null),i&&(i.releaseStreams(),i=null)},this.addStreams=function(n){if(!n)throw"First parameter is required.";n instanceof Array||(n=[n]),e.concat(n),o&&i&&(i.appendStreams(n),t.previewStream&&"function"===typeof t.previewStream&&t.previewStream(i.getMixedStream()))},this.resetVideoStreams=function(e){i&&(!e||e instanceof Array||(e=[e]),i.resetVideoStreams(e))},this.getMixer=function(){return i},this.name="MultiStreamRecorder",this.toString=function(){return this.name}}
/**
 * RecordRTCPromisesHandler adds promises support in {@link RecordRTC}. Try a {@link https://github.com/muaz-khan/RecordRTC/blob/master/simple-demos/RecordRTCPromisesHandler.html|demo here}
 * @summary Promises for {@link RecordRTC}
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef RecordRTCPromisesHandler
 * @class
 * @example
 * var recorder = new RecordRTCPromisesHandler(mediaStream, options);
 * recorder.startRecording()
 *         .then(successCB)
 *         .catch(errorCB);
 * // Note: You can access all RecordRTC API using "recorder.recordRTC" e.g. 
 * recorder.recordRTC.onStateChanged = function(state) {};
 * recorder.recordRTC.setRecordingDuration(5000);
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - Single media-stream object, array of media-streams, html-canvas-element, etc.
 * @param {object} config - {type:"video", recorderType: MediaStreamRecorder, disableLogs: true, numberOfAudioChannels: 1, bufferSize: 0, sampleRate: 0, video: HTMLVideoElement, etc.}
 * @throws Will throw an error if "new" keyword is not used to initiate "RecordRTCPromisesHandler". Also throws error if first argument "MediaStream" is missing.
 * @requires {@link RecordRTC}
 */
function z(e,t){if(!this)throw'Use "new RecordRTCPromisesHandler()"';if("undefined"===typeof e)throw'First argument "MediaStream" is required.';var i=this;i.recordRTC=new a(e,t),this.startRecording=function(){return new Promise(function(e,t){try{i.recordRTC.startRecording(),e()}catch(o){t(o)}})},this.stopRecording=function(){return new Promise(function(e,t){try{i.recordRTC.stopRecording(function(o){i.blob=i.recordRTC.getBlob(),i.blob&&i.blob.size?e(o):t("Empty blob.",i.blob)})}catch(o){t(o)}})},this.pauseRecording=function(){return new Promise(function(e,t){try{i.recordRTC.pauseRecording(),e()}catch(o){t(o)}})},this.resumeRecording=function(){return new Promise(function(e,t){try{i.recordRTC.resumeRecording(),e()}catch(o){t(o)}})},this.getDataURL=function(e){return new Promise(function(e,t){try{i.recordRTC.getDataURL(function(t){e(t)})}catch(o){t(o)}})},this.getBlob=function(){return new Promise(function(e,t){try{e(i.recordRTC.getBlob())}catch(o){t(o)}})},this.getInternalRecorder=function(){return new Promise(function(e,t){try{e(i.recordRTC.getInternalRecorder())}catch(o){t(o)}})},this.reset=function(){return new Promise(function(e,t){try{e(i.recordRTC.reset())}catch(o){t(o)}})},this.destroy=function(){return new Promise(function(e,t){try{e(i.recordRTC.destroy())}catch(o){t(o)}})},this.getState=function(){return new Promise(function(e,t){try{e(i.recordRTC.getState())}catch(o){t(o)}})},this.blob=null,this.version="5.6.1"}
/**
 * WebAssemblyRecorder lets you create webm videos in JavaScript via WebAssembly. The library consumes raw RGBA32 buffers (4 bytes per pixel) and turns them into a webm video with the given framerate and quality. This makes it compatible out-of-the-box with ImageData from a CANVAS. With realtime mode you can also use webm-wasm for streaming webm videos.
 * @summary Video recording feature in Chrome, Firefox and maybe Edge.
 * @license {@link https://github.com/muaz-khan/RecordRTC/blob/master/LICENSE|MIT}
 * @author {@link https://MuazKhan.com|Muaz Khan}
 * @typedef WebAssemblyRecorder
 * @class
 * @example
 * var recorder = new WebAssemblyRecorder(mediaStream);
 * recorder.record();
 * recorder.stop(function(blob) {
 *     video.src = URL.createObjectURL(blob);
 * });
 * @see {@link https://github.com/muaz-khan/RecordRTC|RecordRTC Source Code}
 * @param {MediaStream} mediaStream - MediaStream object fetched using getUserMedia API or generated using captureStreamUntilEnded or WebAudio API.
 * @param {object} config - {webAssemblyPath:'webm-wasm.wasm',workerPath: 'webm-worker.js', frameRate: 30, width: 1920, height: 1080, bitrate: 1024, realtime: true}
 */
function N(e,t){var i,o,n;function r(){return new ReadableStream({start:function(o){var n=document.createElement("canvas"),r=document.createElement("video"),a=!0;r.srcObject=e,r.muted=!0,r.height=t.height,r.width=t.width,r.volume=0,r.onplaying=function(){n.width=t.width,n.height=t.height;var e=n.getContext("2d"),d=1e3/t.frameRate,s=setInterval(function(){if(i&&(clearInterval(s),o.close()),a&&(a=!1,t.onVideoProcessStarted&&t.onVideoProcessStarted()),e.drawImage(r,0,0),"closed"!==o._controlledReadableStream.state)try{o.enqueue(e.getImageData(0,0,t.width,t.height))}catch(n){}},d)},r.play()}})}function a(e,d){if(!t.workerPath&&!d)return i=!1,void fetch("https://unpkg.com/webm-wasm@latest/dist/webm-worker.js").then(function(t){t.arrayBuffer().then(function(t){a(e,t)})});if(!t.workerPath&&d instanceof ArrayBuffer){var c=new Blob([d],{type:"text/javascript"});t.workerPath=g.createObjectURL(c)}t.workerPath||console.error("workerPath parameter is missing."),o=new Worker(t.workerPath),o.postMessage(t.webAssemblyPath||"https://unpkg.com/webm-wasm@latest/dist/webm-wasm.wasm"),o.addEventListener("message",function(e){"READY"===e.data?(o.postMessage({width:t.width,height:t.height,bitrate:t.bitrate||1200,timebaseDen:t.frameRate||30,realtime:t.realtime}),r().pipeTo(new WritableStream({write:function(e){i?console.error("Got image, but recorder is finished!"):o.postMessage(e.data.buffer,[e.data.buffer])}}))):e.data&&(n||s.push(e.data))})}function d(e){o?(o.addEventListener("message",function(t){null===t.data&&(o.terminate(),o=null,e&&e())}),o.postMessage(null)):e&&e()}"undefined"!==typeof ReadableStream&&"undefined"!==typeof WritableStream||console.error("Following polyfill is strongly recommended: https://unpkg.com/@mattiasbuelens/web-streams-polyfill/dist/polyfill.min.js"),t=t||{},t.width=t.width||640,t.height=t.height||480,t.frameRate=t.frameRate||30,t.bitrate=t.bitrate||1200,t.realtime=t.realtime||!0,this.record=function(){s=[],n=!1,this.blob=null,a(e),"function"===typeof t.initCallback&&t.initCallback()},this.pause=function(){n=!0},this.resume=function(){n=!1};var s=[];this.stop=function(e){i=!0;var t=this;d(function(){t.blob=new Blob(s,{type:"video/webm"}),e(t.blob)})},this.name="WebAssemblyRecorder",this.toString=function(){return this.name},this.clearRecordedData=function(){s=[],n=!1,this.blob=null},this.blob=null}"undefined"!==typeof a&&(a.DiskStorage=O),"undefined"!==typeof a&&(a.GifRecorder=F),"undefined"===typeof a&&(e.exports=P,n=[],r=function(){return P}.apply(t,n),void 0===r||(e.exports=r)),"undefined"!==typeof a&&(a.MultiStreamRecorder=j),"undefined"!==typeof a&&(a.RecordRTCPromisesHandler=z),"undefined"!==typeof a&&(a.WebAssemblyRecorder=N)}).call(this,i("c8ba"),i("4362"))},df43:function(e,t,i){e.exports=i.p+"static/img/Recording.a8947b74.svg"}}]);